/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.computer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cz.insophy.inplan.report.LinkedNode;
import cz.insophy.inplan.report.computer.AbstractReportComputer;
import cz.insophy.inplan.report.result.MultiRequestFlowPath;
import cz.insophy.inplan.report.result.MultiRequestFlowResult;
import cz.insophy.inplan.sdgraph.SdgCrNode;
import cz.insophy.inplan.sdgraph.SdgGorNode;
import cz.insophy.inplan.sdgraph.SdgNode;
import cz.insophy.inplan.sdgraph.SdgNodeVisitors;
import cz.insophy.inplan.sdgraph.StoreDependencyGraph;
import cz.insophy.inplan.superplan.Superplan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public class MultiRequestFlowComputer
extends AbstractReportComputer<MultiRequestFlowResult> {
    private SdgNode root = null;

    public void setRootObject(SdgGorNode gorNode) {
        this.root = gorNode;
    }

    public void setRootObject(SdgCrNode crNode) {
        this.root = crNode;
    }

    @Override
    public MultiRequestFlowResult compute(Superplan superplan) {
        if (this.root == null) {
            throw new IllegalStateException();
        }
        StoreDependencyGraph sdg = superplan.getSDGraph();
        ArrayList<MultiRequestFlowPath> paths = Lists.newArrayList(MultiRequestFlowComputer.findPaths(sdg, this.root));
        for (MultiRequestFlowPath path : paths) {
            path.setup(paths);
        }
        for (MultiRequestFlowPath path : paths) {
            path.initialize();
        }
        return new MultiRequestFlowResult(paths);
    }

    private static Set<MultiRequestFlowPath> findPaths(StoreDependencyGraph sdg, SdgNode root) {
        LinkedList<LinkedNode<SdgNode>> leaves = Lists.newLinkedList();
        MultiRequestFlowComputer.findPathsRecursive(sdg, new LinkedNode<SdgNode>(root), leaves);
        LinkedHashSet<MultiRequestFlowPath> paths = Sets.newLinkedHashSet();
        for (LinkedNode linkedNode : leaves) {
            MultiRequestFlowPath path = new MultiRequestFlowPath(linkedNode, sdg);
            if (path.isEmpty()) continue;
            paths.add(path);
        }
        return Collections.unmodifiableSet(paths);
    }

    private static void findPathsRecursive(StoreDependencyGraph sdg, LinkedNode<SdgNode> parent, Collection<LinkedNode<SdgNode>> leaves) {
        Set<SdgNode> dependencies = parent.getValue().getDirectPredecessors();
        boolean isLeaf = true;
        if (!dependencies.isEmpty()) {
            for (SdgNode node : dependencies) {
                if (!MultiRequestFlowComputer.isNodeSupported(node)) continue;
                isLeaf = false;
                LinkedNode<SdgNode> child = new LinkedNode<SdgNode>(node, parent);
                MultiRequestFlowComputer.findPathsRecursive(sdg, child, leaves);
            }
        }
        if (isLeaf) {
            leaves.add(parent);
        }
    }

    private static boolean isNodeSupported(SdgNode node) {
        return node.accept(SdgNodeVisitors.IS_GOR);
    }
}

